<?php

use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Install.php kontrolü - Kurulum yapılmamışsa install.php'yi çalıştır
if (file_exists(__DIR__ . '/install.php')) {
    // Kurulum yapılmış mı kontrol et
    $installed = file_exists(__DIR__ . '/../storage/installed.lock');
    $envExists = file_exists(__DIR__ . '/../.env');
    $envHasKey = false;
    
    if ($envExists) {
        $envContent = @file_get_contents(__DIR__ . '/../.env');
        // APP_KEY var mı ve boş değil mi kontrol et
        $envHasKey = $envContent && preg_match('/^APP_KEY=(.+)$/m', $envContent, $matches) && 
                     !empty(trim($matches[1]));
    }
    
    // Eğer kurulum yapılmamışsa install.php'yi çalıştır
    if (!$installed || !$envExists || !$envHasKey) {
        require __DIR__ . '/install.php';
        exit;
    }
}

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = __DIR__.'/../storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require __DIR__.'/../vendor/autoload.php';

// Bootstrap Laravel and handle the request...
(require_once __DIR__.'/../bootstrap/app.php')
    ->handleRequest(Request::capture());

